/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoader;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class TaskSoftwareDistribution
extends Task {
    private static final String FILE_STATUS_FAILED = "1";
    private static final String SD_FILE_LIST_SUFFIX = ".txt";
    private static final String SD_FILE_LIST_PREFIX = "softwareDistributionFileList";
    private static final String TAG_FILE = "FILE";
    private String m_softwareComponent;
    private String m_softwareComponentHome;
    private String m_configFile;
    private String m_release;
    private boolean m_verifyAll = false;
    private Properties crsConfigVariables = new Properties();
    private boolean crsConfigDefsLoaded = false;
    private Pattern instatiatedVariablePattern = Pattern.compile("([^%]*)%([^%]+)%(.*)");
    private Pattern envVariablePattern = Pattern.compile("([^$]*)\\$([^/$]+)(.*)");

    public TaskSoftwareDistribution(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, String configFile, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing Software verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4375", false));
        this.performSoftwareChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4376", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4377", false));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSoftwareChecks() {
        String fileName;
        int nodeCount = this.m_nodeList.length;
        String destinationfileName = null;
        String sourceFile = null;
        HashMap compFileList = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String localNodeName = VerificationUtil.getLocalHostName();
        ArrayList<FileInfo> hostSpecificFiles = new ArrayList<FileInfo>();
        try {
            this.m_configFile = VerificationUtil.getCompSoftwareConfigXmlPath(this.m_softwareComponentHome, this.m_release);
            File softwareConfigFile = new File(this.m_configFile);
            if (!softwareConfigFile.exists()) {
                this.m_configFile = VerificationUtil.getCompSoftwareConfigXmlPath(this.m_release);
            }
            CompSoftwareConfigLoader loader = new CompSoftwareConfigLoader(this.m_configFile, this.m_softwareComponent);
            File tmpFile = File.createTempFile(SD_FILE_LIST_PREFIX, SD_FILE_LIST_SUFFIX, new File(VerificationUtil.getDestLoc()));
            tmpFile.deleteOnExit();
            FileWriter tmpFileWriter = new FileWriter(tmpFile);
            BufferedWriter writer = new BufferedWriter(tmpFileWriter);
            compFileList = loader.load(this.m_verifyAll);
            boolean haCompFound = false;
            for (String compName : compFileList.keySet()) {
                if (!"ha".equalsIgnoreCase(compName)) continue;
                haCompFound = true;
                break;
            }
            Iterator compIter = compFileList.keySet().iterator();
            while (compIter.hasNext()) {
                String comp = compIter.next().toString();
                if (this.m_softwareComponent != null) {
                    if (this.m_softwareComponent.equalsIgnoreCase("ha") && !haCompFound && !"crs".equalsIgnoreCase(comp)) {
                        Trace.out((String)("Check for component " + this.m_softwareComponent + " requested. HACopmpFound = " + haCompFound + ". Skipping files for component: " + comp));
                        continue;
                    }
                    if (!this.m_softwareComponent.equalsIgnoreCase(comp)) {
                        Trace.out((String)("Check for component " + this.m_softwareComponent + " requested. Skipping files for component: " + comp));
                        continue;
                    }
                }
                List fileList = (List)compFileList.get(comp);
                Iterator fileListIterator = fileList.iterator();
                while (fileListIterator.hasNext()) {
                    FileInfo file = (FileInfo)fileListIterator.next();
                    fileName = file.getFileName();
                    String refOwner = this.resolveVariables(file.getFileOwner());
                    String refGroup = this.resolveVariables(file.getFileGroup());
                    file.setFileOwner(refOwner);
                    file.setFileGroup(refGroup);
                    if (this.containsVariables(refOwner) || this.containsVariables(refGroup)) {
                        Trace.out((int)5, (String)"File name=%s, owner=%s, group=%s will not be checked because it owner/group has unresolved variables ", (Object[])new Object[]{file.getFileName(), file.getFileOwner(), file.getFileGroup()});
                        fileListIterator.remove();
                        continue;
                    }
                    if (fileName.contains("$HOST") || fileName.contains("%HOST%")) {
                        String hostKey = fileName.contains("$HOST") ? "$HOST" : "%HOST%";
                        fileName = fileName.replaceAll(Pattern.quote(hostKey), "#HOST#");
                        if ((fileName = this.resolveVariables(fileName)) == null || this.containsVariables(fileName)) {
                            Trace.out((int)5, (String)"File name=%s, will not be checked because it has unresolved variables ", (Object[])new Object[]{file.getFileName()});
                            fileListIterator.remove();
                            continue;
                        }
                        if (!new File(fileName).isAbsolute()) {
                            fileName = this.m_softwareComponentHome + File.separator + fileName;
                        }
                        hostKey = hostKey.replace("$", "\\$");
                        fileName = fileName.replaceAll("#HOST#", hostKey);
                        file.setFileName(fileName);
                        hostSpecificFiles.add(file);
                        continue;
                    }
                    if ((fileName = this.resolveVariables(fileName)) == null || this.containsVariables(fileName)) {
                        Trace.out((int)5, (String)"File name=%s, will not be checked because it has unresolved variables ", (Object[])new Object[]{file.getFileName()});
                        fileListIterator.remove();
                        continue;
                    }
                    if (!new File(fileName).isAbsolute()) {
                        fileName = this.m_softwareComponentHome + File.separator + fileName;
                    }
                    file.setFileName(fileName);
                    writer.write(fileName + System.getProperty("line.separator"));
                }
            }
            writer.close();
            sourceFile = tmpFile.getAbsolutePath();
            destinationfileName = File.createTempFile(SD_FILE_LIST_PREFIX, SD_FILE_LIST_SUFFIX, new File(VerificationUtil.getDestLoc())).getAbsolutePath();
        }
        catch (CompSoftwareConfigLoaderException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (IOException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (XmlFilePathException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        ResultSet resultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.copyFile(this.m_nodeList, sourceFile, destinationfileName, resultSet);
        this.m_resultSet.uploadResultSet(resultSet);
        if (!resultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5001", false);
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(message);
            return;
        }
        VerificationCommand[] fileInfoCmdArray = new VerificationCommand[nodeCount];
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = new String[]{"-getfileinfo", destinationfileName};
            String[] env = null;
            fileInfoCmdArray[j] = new VerificationCommand(this.m_nodeList[j], arg, env);
        }
        resultSet = new ResultSet();
        new GlobalHandler().submit((Command[])fileInfoCmdArray, 0, resultSet);
        this.m_resultSet.uploadResultSet(resultSet);
        if (!resultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5002", false, (Object[])new String[]{localNodeName});
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(message);
            return;
        }
        Hashtable<String, Hashtable<String, FileInfo>> nodeValues = new Hashtable<String, Hashtable<String, FileInfo>>();
        HashSet<String> execkTaskFailedNodes = new HashSet<String>();
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            FileInfo fileInfo;
            String node;
            VerificationCommand fileInfoCmd = fileInfoCmdArray[nodeIndex];
            Result result = fileInfoCmd.getResult();
            if (result.getStatus() == 1) {
                ErrorDescription errorDesc;
                node = fileInfoCmd.getNode();
                String outputFileName = fileInfoCmd.getOutput();
                String shortFileName = outputFileName.substring(outputFileName.lastIndexOf(File.separator) + 1);
                String destinationFileName = VerificationUtil.getDestLoc() + node + "." + shortFileName;
                nativeSys.copyFile(node, outputFileName, localNodeName, destinationFileName);
                File destinationFile = new File(destinationFileName);
                if (!destinationFile.exists()) {
                    this.m_resultSet.addResult(node, 2);
                    ErrorDescription errorDesc2 = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc2);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                StringBuffer outputBuffer = new StringBuffer();
                try {
                    String line;
                    BufferedReader destinationFileBR = new BufferedReader(new FileReader(destinationFile));
                    while ((line = destinationFileBR.readLine()) != null) {
                        outputBuffer.append(line);
                    }
                    destinationFileBR.close();
                }
                catch (FileNotFoundException e) {
                    this.m_resultSet.addResult(node, 2);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                catch (IOException e) {
                    this.m_resultSet.addResult(node, 2);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                finally {
                    nativeSys.removeFile(node, outputFileName);
                    nativeSys.removeFile(localNodeName, destinationFileName);
                }
                Hashtable<String, FileInfo> fileList = new Hashtable<String, FileInfo>();
                nodeValues.put(node, fileList);
                Vector infStrs = null;
                try {
                    String output = outputBuffer.toString().replaceAll("\n", "");
                    infStrs = GenericUtil.getAllStrByTags(output, TAG_FILE);
                    for (Object fmtdObj : infStrs) {
                        String fmtdStr = (String)fmtdObj;
                        fileInfo = new FileInfo();
                        fileInfo.setStatus(GenericUtil.getValueByKey(fmtdStr, "STATUS"));
                        fileInfo.setErrorString(GenericUtil.getValueByKey(fmtdStr, "ERROR"));
                        fileInfo.setFileName(GenericUtil.getValueByKey(fmtdStr, "NAME"));
                        fileInfo.setFileOwner(GenericUtil.getValueByKey(fmtdStr, "USER"));
                        fileInfo.setFileGroup(GenericUtil.getValueByKey(fmtdStr, "GROUP"));
                        fileInfo.setFilePermissions(GenericUtil.getValueByKey(fmtdStr, "PERMISSIONS"));
                        fileList.put(fileInfo.getFileName(), fileInfo);
                    }
                }
                catch (ParsingException p) {
                    Trace.out((Exception)p);
                    this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
                    ErrorDescription errorDesc3 = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{fileInfoCmd.getNode()}));
                    this.m_resultSet.addErrorDescription(fileInfoCmd.getNode(), errorDesc3);
                    this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
                    execkTaskFailedNodes.add(fileInfoCmd.getNode());
                }
            } else {
                this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{fileInfoCmd.getNode()}));
                this.m_resultSet.addErrorDescription(fileInfoCmd.getNode(), errorDesc);
                execkTaskFailedNodes.add(fileInfoCmd.getNode());
            }
            if (hostSpecificFiles.size() <= 0) continue;
            node = fileInfoCmd.getNode();
            ArrayList<String> fileList = new ArrayList<String>();
            String hostKey = null;
            for (FileInfo file : hostSpecificFiles) {
                fileName = file.getFileName();
                hostKey = fileName.contains("$HOST") ? "$HOST" : "%HOST%";
                fileName = fileName.replaceAll(Pattern.quote(hostKey), node);
                fileList.add(fileName);
            }
            ResultSet hostSpecificFileRS = new ResultSet();
            globalExec.getFileInfo(new String[]{node}, fileList, hostSpecificFileRS);
            Result nodeResult = hostSpecificFileRS.getResult(node);
            if (nodeResult == null || nodeResult.getStatus() != 1) {
                execkTaskFailedNodes.add(node);
                continue;
            }
            Hashtable nodeFileList = (Hashtable)nodeResult.getResultInfoSet().elementAt(0);
            Hashtable<String, FileInfo> nodeFilesWithHostReplacedBack = new Hashtable<String, FileInfo>();
            Iterator nodeFileKeys = nodeFileList.keySet().iterator();
            hostKey = hostKey.replace("$", "\\$");
            for (FileInfo file : hostSpecificFiles) {
                String originalFileName;
                hostKey = (originalFileName = file.getFileName()).contains("$HOST") ? "$HOST" : "%HOST%";
                String fileName2 = originalFileName.replaceAll(Pattern.quote(hostKey), node);
                fileInfo = (FileInfo)nodeFileList.get(fileName2);
                if (fileInfo == null) continue;
                fileInfo.setFileName(originalFileName);
                nodeFilesWithHostReplacedBack.put(originalFileName, file);
            }
            Hashtable<String, FileInfo> commonFiles = nodeValues.get(node);
            if (commonFiles != null) {
                commonFiles.putAll(nodeFilesWithHostReplacedBack);
                continue;
            }
            nodeValues.put(node, nodeFilesWithHostReplacedBack);
        }
        if (!execkTaskFailedNodes.isEmpty()) {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5010", false));
            ReportUtil.sureprintNodelist(execkTaskFailedNodes);
        }
        this.reportResults(compFileList, nodeValues);
        resultSet = new ResultSet();
        globalExec.deleteFile(this.m_nodeList, destinationfileName, resultSet);
    }

    private boolean containsVariables(String str) {
        if (!VerificationUtil.isStringGood(str)) {
            return false;
        }
        return this.instatiatedVariablePattern.matcher(str).matches() || this.envVariablePattern.matcher(str).matches();
    }

    private String resolveVariables(String str) {
        if (!VerificationUtil.isStringGood(str)) {
            return str;
        }
        String returnValue = str;
        if (this.instatiatedVariablePattern.matcher(returnValue).matches()) {
            returnValue = this.resolveInstantaitedVariables(str);
        }
        if (!VerificationUtil.isStringGood(returnValue)) {
            return returnValue;
        }
        if (this.envVariablePattern.matcher(returnValue).matches()) {
            returnValue = this.resolveEnvVariables(returnValue);
        }
        return returnValue;
    }

    private String resolveInstantaitedVariables(String fileName) {
        String returnValue;
        block7: {
            if (fileName == null) {
                return null;
            }
            returnValue = null;
            try {
                Matcher m = this.instatiatedVariablePattern.matcher(fileName);
                if (m.matches()) {
                    while (m.matches()) {
                        returnValue = m.group(1);
                        String resolvableVar = m.group(2);
                        String resolvedValue = this.resolveEnvVariables(resolvableVar);
                        if (resolvedValue == null) {
                            returnValue = null;
                            break block7;
                        }
                        returnValue = returnValue + resolvedValue;
                        returnValue = returnValue + m.group(3);
                        m = this.instatiatedVariablePattern.matcher(returnValue);
                    }
                    break block7;
                }
                returnValue = fileName;
            }
            catch (Exception e) {
                Trace.out((int)5, (String)"IGNORED EXCEPTION : %s : %s during processing of file %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
            }
        }
        if (returnValue == null) {
            Trace.out((int)5, (String)"Could not expand filename %s", (Object[])new Object[]{fileName});
        }
        return returnValue;
    }

    private String resolveEnvVariables(String variable) {
        String returnValue;
        block8: {
            Object returnValueObject;
            if (!VerificationUtil.isStringGood(variable)) {
                return null;
            }
            if (!this.crsConfigDefsLoaded) {
                this.loadCRSConfigDefs();
            }
            if ((returnValueObject = this.crsConfigVariables.get(variable)) == null) {
                return null;
            }
            returnValue = String.valueOf(returnValueObject);
            try {
                Matcher m = this.envVariablePattern.matcher(returnValue);
                if (!m.matches()) break block8;
                while (m.matches()) {
                    returnValue = m.group(1);
                    String resolvableVar = m.group(2);
                    String resolvedValue = this.resolveEnvVariables(resolvableVar);
                    if (resolvedValue == null) {
                        returnValue = null;
                        break;
                    }
                    returnValue = returnValue + resolvedValue;
                    returnValue = returnValue + m.group(3);
                    m = this.envVariablePattern.matcher(returnValue);
                }
            }
            catch (Exception e) {
                Trace.out((int)5, (String)"IGNORED EXCEPTION : %s : %s during processing of variable %s", (Object[])new Object[]{e.getClass(), e.getMessage(), returnValue});
            }
        }
        if (returnValue == null) {
            Trace.out((int)5, (String)"Could not expand variable %s", (Object[])new Object[]{returnValue});
        }
        return returnValue;
    }

    private void loadCRSConfigDefs() {
        BufferedReader br;
        this.crsConfigDefsLoaded = true;
        String fileName = this.m_softwareComponentHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params";
        try {
            br = new BufferedReader(new FileReader(fileName));
            this.crsConfigVariables.load(br);
        }
        catch (FileNotFoundException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s:%s during loading properites from %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
        }
        catch (IOException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s:%s during loading properites from %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
        }
        fileName = this.m_softwareComponentHome + File.separator + "crs" + File.separator + "install" + File.separator + "s_crsconfig_defs";
        try {
            br = new BufferedReader(new FileReader(fileName));
            this.crsConfigVariables.load(br);
        }
        catch (FileNotFoundException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s:%s during loading properites from %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
        }
        catch (IOException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s:%s during loading properites from %s", (Object[])new Object[]{e.getClass(), e.getMessage(), fileName});
        }
    }

    private void reportResults(HashMap<String, List<FileInfo>> refCompFileTable, Hashtable<String, Hashtable<String, FileInfo>> nodeExecTaskValues) {
        for (String compName : refCompFileTable.keySet()) {
            Hashtable nodeBasedResultTable = new Hashtable();
            List<FileInfo> refFileList = refCompFileTable.get(compName);
            for (FileInfo refFileInfo : refFileList) {
                List<Hashtable<String, String>> mismatchAttributeList;
                FileInfo nodeFileInfo;
                Hashtable<String, String> mismatchAttributeMap;
                ErrorDescription error;
                String errorMessage;
                CharSequence errorMessage2;
                String refFileName = refFileInfo.getFileName();
                String refOwner = refFileInfo.getFileOwner();
                String refGroup = refFileInfo.getFileGroup();
                String refPermissions = refFileInfo.getFilePermissions();
                HashMap<String, ArrayList<String>> fileOwnerMap = new HashMap<String, ArrayList<String>>();
                HashMap fileGroupMap = new HashMap();
                HashMap filePermissionsMap = new HashMap();
                ArrayList<String> successfulNodes = new ArrayList<String>();
                Hashtable referenceAttributeMismatchMap = new Hashtable();
                ArrayList<CollectionElement> fileCollectionElementList = new ArrayList<CollectionElement>();
                for (String node : nodeExecTaskValues.keySet()) {
                    List<String> nodeList;
                    List<Hashtable<String, CharSequence>> mismatchAttributeList2;
                    Hashtable<String, CharSequence> mismatchAttributeMap2;
                    ErrorDescription error2;
                    Hashtable<String, FileInfo> nodeFileInfoTable = nodeExecTaskValues.get(node);
                    FileInfo nodeFileInfo2 = nodeFileInfoTable.get(refFileName);
                    if (nodeFileInfo2 == null) {
                        Trace.out((int)5, (String)("Could not retrieve nodeFileInfo for file: " + refFileName));
                    }
                    CollectionElement fileCollectionElement = new CollectionElement(refFileName, null, null, null, refFileName, 1);
                    fileCollectionElementList.add(fileCollectionElement);
                    this.m_resultSet.addCollectionElement(node, fileCollectionElement);
                    String referenceValue = null;
                    if (refOwner != null) {
                        referenceValue = "Owner=" + refOwner;
                    }
                    if (refGroup != null) {
                        referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
                    }
                    if (refPermissions != null) {
                        referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
                    }
                    if (referenceValue == null) {
                        referenceValue = "EXISTS";
                    }
                    fileCollectionElement.setExpectedValue(referenceValue);
                    if (nodeFileInfo2 == null || FILE_STATUS_FAILED.equals(nodeFileInfo2.getStatus())) {
                        ArrayList nodeFailedFileList = (ArrayList)nodeBasedResultTable.get(node);
                        if (nodeFailedFileList == null) {
                            nodeFailedFileList = new ArrayList();
                            nodeBasedResultTable.put(node, nodeFailedFileList);
                        }
                        Hashtable<String, String> fileTable = new Hashtable<String, String>();
                        fileTable.put("FILE_NAME", refFileName);
                        String errorString = nodeFileInfo2 != null ? nodeFileInfo2.getErrorString() : ReportUtil.NOT_APPLICABLE;
                        fileTable.put("ERROR", errorString);
                        nodeFailedFileList.add(fileTable);
                        this.m_resultSet.addResult(node, 3);
                        fileCollectionElement.setStatus(3);
                        ErrorDescription error3 = new ErrorDescription(s_msgBundle.getMessage("5003", false, (Object[])new String[]{refFileName, node, errorString}));
                        this.m_resultSet.addErrorDescription(node, error3);
                        fileCollectionElement.addErrorDescription(error3);
                        continue;
                    }
                    String nodeValue = "Owner=" + nodeFileInfo2.getFileOwner() + "; Group=" + nodeFileInfo2.getFileGroup() + "; Permissions=" + nodeFileInfo2.getFilePermissions();
                    fileCollectionElement.setValue(nodeValue);
                    if (refOwner != null) {
                        if (!refOwner.equals(nodeFileInfo2.getFileOwner())) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_gMsgBundle.getMessage("2031", false, (Object[])new String[]{refFileName, node, refOwner, nodeFileInfo2.getFileOwner()});
                            error2 = new ErrorDescription((String)errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            fileCollectionElement.setStatus(3);
                            fileCollectionElement.addErrorDescription(error2);
                            mismatchAttributeMap2 = new Hashtable<String, CharSequence>();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Owner");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList2 = (ArrayList)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList2 == null) {
                                mismatchAttributeList2 = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                            }
                            mismatchAttributeList2.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFileOwner() != null) {
                        nodeList = (ArrayList<String>)fileOwnerMap.get(nodeFileInfo2.getFileOwner());
                        if (nodeList == null) {
                            nodeList = new ArrayList<String>();
                            fileOwnerMap.put(nodeFileInfo2.getFileOwner(), (ArrayList<String>)nodeList);
                        }
                        nodeList.add(node);
                    }
                    if (refGroup != null) {
                        if (!refGroup.equals(nodeFileInfo2.getFileGroup())) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_gMsgBundle.getMessage("2032", false, (Object[])new String[]{refFileName, node, refGroup, nodeFileInfo2.getFileGroup()});
                            error2 = new ErrorDescription((String)errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            fileCollectionElement.setStatus(3);
                            fileCollectionElement.addErrorDescription(error2);
                            mismatchAttributeMap2 = new Hashtable();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Group");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList2 = (List)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList2 == null) {
                                mismatchAttributeList2 = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                            }
                            mismatchAttributeList2.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFileGroup() != null) {
                        nodeList = (List)fileGroupMap.get(nodeFileInfo2.getFileGroup());
                        if (nodeList == null) {
                            nodeList = new ArrayList();
                            fileGroupMap.put(nodeFileInfo2.getFileGroup(), nodeList);
                        }
                        nodeList.add(node);
                    }
                    if (refPermissions != null) {
                        if (Integer.parseInt(refPermissions, 8) != Integer.parseInt(nodeFileInfo2.getFilePermissions(), 8)) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_gMsgBundle.getMessage("2033", false, (Object[])new String[]{refFileName, node, refPermissions, nodeFileInfo2.getFilePermissions()});
                            error2 = new ErrorDescription((String)errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            fileCollectionElement.setStatus(3);
                            fileCollectionElement.addErrorDescription(error2);
                            mismatchAttributeMap2 = new Hashtable();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Permissions");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList2 = (List)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList2 == null) {
                                mismatchAttributeList2 = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList2);
                            }
                            mismatchAttributeList2.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFilePermissions() != null) {
                        nodeList = (List)filePermissionsMap.get(nodeFileInfo2.getFilePermissions());
                        if (nodeList == null) {
                            nodeList = new ArrayList();
                            filePermissionsMap.put(nodeFileInfo2.getFilePermissions(), nodeList);
                        }
                        nodeList.add(node);
                    }
                    successfulNodes.add(node);
                }
                Hashtable nodeAttributeMismatchMap = new Hashtable();
                if (fileOwnerMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_gMsgBundle.getMessage("2027", false, (Object[])new String[]{refFileName, fileOwnerMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable<String, String>();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Owner");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (ArrayList)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                if (fileGroupMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_gMsgBundle.getMessage("2028", false, (Object[])new String[]{refFileName, fileGroupMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Group");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                if (filePermissionsMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_gMsgBundle.getMessage("2029", false, (Object[])new String[]{refFileName, filePermissionsMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Permissions");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                for (String node : successfulNodes) {
                    String message;
                    List nodeMismatchedList = (List)nodeAttributeMismatchMap.get(node);
                    List referenceMismatchedList = (List)referenceAttributeMismatchMap.get(node);
                    ArrayList attributesMismatched = new ArrayList();
                    ArrayList detailedMessage = new ArrayList();
                    errorMessage2 = new StringBuffer();
                    boolean mismatchFound = false;
                    if (nodeMismatchedList != null) {
                        mismatchFound = true;
                        for (Hashtable mismatchedAttributeMap : nodeMismatchedList) {
                            attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                            detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                        }
                        message = s_gMsgBundle.getMessage("5011", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                        errorMessage2.append(message);
                    }
                    attributesMismatched = new ArrayList();
                    if (referenceMismatchedList != null) {
                        mismatchFound = true;
                        for (Hashtable mismatchedAttributeMap : referenceMismatchedList) {
                            attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                            detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                        }
                        message = s_gMsgBundle.getMessage("5012", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                        if (errorMessage2.length() > 0) {
                            errorMessage2.append(";");
                        }
                        errorMessage2.append(message);
                    }
                    if (!mismatchFound) continue;
                    ArrayList nodeFailedFileList = (ArrayList)nodeBasedResultTable.get(node);
                    if (nodeFailedFileList == null) {
                        nodeFailedFileList = new ArrayList();
                        nodeBasedResultTable.put(node, nodeFailedFileList);
                    }
                    Hashtable<String, Object> fileTable = new Hashtable<String, Object>();
                    fileTable.put("FILE_NAME", refFileName);
                    fileTable.put("ERROR", errorMessage2.toString());
                    fileTable.put("DETAILED_ERROR", detailedMessage);
                    nodeFailedFileList.add(fileTable);
                }
            }
            if (nodeBasedResultTable.size() > 0) {
                ReportUtil.sureblankln();
                ReportUtil.surewriteRecord(ReportUtil.COMPONENT + ": " + compName);
                ReportUtil.sureblankln();
                for (String node : nodeBasedResultTable.keySet()) {
                    ReportUtil.surewriteRecord(ReportUtil.NODENAME + ": " + node);
                    int failedCount = 0;
                    for (Hashtable failedFileTable : (List)nodeBasedResultTable.get(node)) {
                        List detailedErrors;
                        if (++failedCount < 5 || ReportUtil.isVerbose()) {
                            ReportUtil.surewriteRecord("  " + failedFileTable.get("FILE_NAME") + "..." + failedFileTable.get("ERROR"));
                        }
                        if ((detailedErrors = (List)failedFileTable.get("DETAILED_ERROR")) == null) continue;
                        for (String detailedError : detailedErrors) {
                            ReportUtil.writeRecord("  \t" + detailedError);
                        }
                    }
                    if (failedCount <= 5 || ReportUtil.isVerbose()) continue;
                    String message = s_msgBundle.getMessage("5013", false, (Object[])new String[]{Integer.toString(failedCount - 5)});
                    ReportUtil.surewriteRecord("  " + message);
                }
            }
            String message = s_msgBundle.getMessage("9602", false, (Object[])new String[]{Integer.toString(refFileList.size())});
            ReportUtil.sureblankln();
            ReportUtil.surewriteRecord(message);
        }
    }

    public void setSoftwareComponent(String softwareComponent) {
        this.m_softwareComponent = softwareComponent;
    }

    public void setSoftwareComponentHome(String softwareComponentHome) {
        this.m_softwareComponentHome = softwareComponentHome;
    }

    public String getSoftwareComponentHome() {
        return this.m_softwareComponentHome;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1400", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1401", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    public void setAll(boolean all) {
        this.m_verifyAll = all;
    }
}

